#!/bin/bash
exp_id=$1
num_shadow=$2

DATA_PATH="datasets"
SAVE_PATH="exps/DM_cinic_init/syn_img"
LIRA_PATH="exps/DM_cinic_init/lira"

python src/dd/main_DM.py \
    --dataset CIFAR10 \
    --model ConvNet \
    --ipc 1000 \
    --dsa_strategy color_crop_cutout_flip_scale_rotate \
    --init cinic10 \
    --cinic $DATA_PATH/cinic10 \
    --lr_img 30 \
    --num_eval 1 \
    --eval_freq 5000 \
    --Iteration 100000 \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --num_canaries 500 \
    --data_path $DATA_PATH \
    --lira_path $LIRA_PATH \
    --save_path $SAVE_PATH > logs/dm/DM_cinic_exp_$exp_id.log